<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <style>
        body { font-family: sans-serif; margin: 0; display: flex; }
        nav { width: 220px; background: #333; color: #fff; height: 100vh; padding: 20px; box-sizing: border-box; }
        nav h3 { color: #fff; }
        nav a { display: block; color: #fff; margin: 10px 0; text-decoration: none; }
        nav li { list-style: none; }
        main { padding: 20px; flex: 1; }
    </style>
</head>
<body>
    <nav>
        <h3>Navigation</h3>
        <ul>
            <?php foreach ($sections as $s): ?>
                <li>
                    <!-- Check if the section belongs to the admin section -->
                    <a href="<?= base_url((strpos($s, 'admin/') === false) ? 'dashboard/' . $s : $s) ?>">
                        <?= ucfirst(basename($s)) ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
        <hr>
        <a href="<?= base_url('auth/logout') ?>">Logout</a>
    </nav>
    <main>
        <?php
        if (!empty($content)) {
            $this->load->view($content);
        } else {
            echo "<p>No content found.</p>";
        }
        ?>
    </main>
</body>
</html>
