<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TradersAPI {
    private $ci;
    private $api_key;
    private $base_url;

    public function __construct() {
        $this->ci =& get_instance();
        $this->ci->config->load('payment_api');  // Load the payment API config
        $this->api_key = $this->ci->config->item('api_key');
        $this->base_url = $this->ci->config->item('test_url'); // Or production URL
    }

    // Function to generate signature using MD5 and TripleDES encryption
    public function generateSignature($str) {
        $data = md5($str, true);
        $key = hex2bin(str_replace('-', '', $this->api_key));  // Remove dashes from the API key
        $key .= substr($key, 0, 8);  // Concatenate key as needed
        $encrypted = openssl_encrypt($data, 'DES-EDE3', $key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING);
        return strtoupper(bin2hex($encrypted));  // Return the encrypted signature
    }

    // Function to call the Get Customer Cards API
    public function getCustomerCards($customerId) {
        $signature = $this->generateSignature($customerId);
        $url = $this->base_url . "/api/Brokers/GetCustomerCards?customerId=$customerId&signature=$signature";

        $headers = [
            'APIKEY: ' . $this->api_key
        ];

        $response = $this->makeRequest($url, 'GET', $headers);
        return json_decode($response, true);
    }

    // Function to handle Card Cash Out
    public function cardCashOut($customerId, $cardId, $depositAmount, $currency, $transactionId, $cardExpiryDate, $otp = '') {
        $signature = $this->generateSignature("$customerId,$cardId,$depositAmount,$currency,$transactionId,$cardExpiryDate");
        $url = $this->base_url . "/api/Brokers/CardCashOut";
        $data = [
            'customerId' => $customerId,
            'cardId' => $cardId,
            'depositAmount' => $depositAmount,
            'currency' => $currency,
            'transactionId' => $transactionId,
            'cardExpiryDate' => $cardExpiryDate,
            'otp' => $otp,
            'signature' => $signature
        ];
        $headers = [
            'APIKEY: ' . $this->api_key,
            'Content-Type: application/json'
        ];
        $response = $this->makeRequest($url, 'POST', $headers, json_encode($data));
        return json_decode($response, true);
    }

    // Function to handle Card Cash In
    public function cardCashIn($customerId, $cardId, $withdrawalAmount, $currency, $transactionId, $cardExpiryDate) {
        $signature = $this->generateSignature("$customerId,$cardId,$withdrawalAmount,$currency,$transactionId,$cardExpiryDate");
        $url = $this->base_url . "/api/Brokers/CardCashIn";
        $data = [
            'customerId' => $customerId,
            'cardId' => $cardId,
            'withdrawalAmount' => $withdrawalAmount,
            'currency' => $currency,
            'transactionId' => $transactionId,
            'cardExpiryDate' => $cardExpiryDate,
            'signature' => $signature
        ];
        $headers = [
            'APIKEY: ' . $this->api_key,
            'Content-Type: application/json'
        ];
        $response = $this->makeRequest($url, 'POST', $headers, json_encode($data));
        return json_decode($response, true);
    }

    // Function to send the API request
    private function makeRequest($url, $method, $headers, $data = null) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        if ($method === 'POST') {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }

        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
}