<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PaymentController extends CI_Controller {

    private $apiKey = '5194825a-f2e7-40cc-90ae-d7286784d1f3';
    private $apiKeyHex = '5194825af2e740cc90aed7286784d1f3'; // API but without dashes
    private $customerId = '3158632';
    private $baseUrl = 'https://tradetest.gatetopay.com';

    public function getCards()
    {
        $signature = $this->getSignature($this->customerId, $this->apiKeyHex);
        $url = $this->baseUrl . "/api/Brokers/GetCustomerCards?customerId={$this->customerId}&signature={$signature}";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'APIKEY: ' . $this->apiKey,
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200) {
            echo "<pre> Card List:\n";
            print_r(json_decode($response, true));
        } else {
            echo "<pre> Failed with HTTP Code $httpCode\n";
            print_r(json_decode($response, true));
        }
    }

    private function getSignature($str, $apiKey)
    {
        $data = md5($str, true);
        $key = hex2bin($apiKey);
        $key .= substr($key, 0, 8);
        $encrypted = openssl_encrypt($data, 'DES-EDE3', $key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING);
        return strtoupper(bin2hex($encrypted));
    }
    
    public function cashIn()
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $apiKeyHex = '5194825af2e740cc90aed7286784d1f3';
        $apiKey = '5194825a-f2e7-40cc-90ae-d7286784d1f3';

        $customerId = $this->input->post('customerId');
        $cardId = $this->input->post('cardId');
        $withdrawalAmount = $this->input->post('amount');
        $currency = $this->input->post('currency');
        $transactionId = uniqid('txn_');
        $cardExpiryDate = $this->input->post('expiry'); // format MM/YY

        // Signature string
        $signatureStr = $customerId . $cardId . $withdrawalAmount . $currency . $transactionId . $cardExpiryDate;
        $signature = $this->getSignature($signatureStr, $apiKeyHex);

        $postData = [
            "customerId" => $customerId,
            "cardId" => $cardId,
            "withdrawalAmount" => $withdrawalAmount,
            "currency" => $currency,
            "transactionId" => $transactionId,
            "cardExpiryDate" => $cardExpiryDate,
            "signature" => $signature
        ];

        $ch = curl_init('https://tradetest.gatetopay.com/api/Brokers/CardCashIn');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'APIKEY: ' . $apiKey
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_POST, true);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        echo "<pre>";
        echo "Status Code: $httpCode\n";
        print_r(json_decode($response, true));
        echo "</pre>";
    } else {
        $this->load->view('cash_in_form');
    }
}
public function cashOut()
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $apiKeyHex = '5194825af2e740cc90aed7286784d1f3';
        $apiKey = '5194825a-f2e7-40cc-90ae-d7286784d1f3';

        $customerId = $this->input->post('customerId');
        $cardId = $this->input->post('cardId');
        $depositAmount = $this->input->post('amount');
        $currency = $this->input->post('currency');
        $transactionId = uniqid('txn_');
        $cardExpiryDate = $this->input->post('expiry'); // MM/YY

        // Signature
        $signatureStr = $customerId . $cardId . $depositAmount . $currency . $transactionId . $cardExpiryDate;
        $signature = $this->getSignature($signatureStr, $apiKeyHex);

        $postData = [
            "customerId" => $customerId,
            "cardId" => $cardId,
            "depositAmount" => $depositAmount,
            "currency" => $currency,
            "transactionId" => $transactionId,
            "cardExpiryDate" => $cardExpiryDate,
            "otp" => "", // skipping if OTP not required
            "signature" => $signature
        ];

        $ch = curl_init('https://tradetest.gatetopay.com/api/Brokers/CardCashOut');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'APIKEY: ' . $apiKey
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_POST, true);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        echo "<pre>";
        echo "Status Code: $httpCode\n";
        print_r(json_decode($response, true));
        echo "</pre>";
    } else {
        $this->load->view('cash_out_form');
    }
}


}