<?php
class User_model extends CI_Model {
    public function get_by_email($email) {
        return $this->db->get_where('users', ['email' => $email])->row();
    }

    public function insert($data) {
        return $this->db->insert('users', $data);
    }

    public function get_roles() {
        return $this->db->get('roles')->result();
    }

    public function create_user($user_data) {
        return $this->db->insert('users', $user_data);
    }

    public function get_all_users() {
        return $this->db->get('users')->result();
    }

    public function get_user_by_id($user_id) {
        return $this->db->get_where('users', ['id' => $user_id])->row();
    }

    public function update_user($user_id, $data) {
        $this->db->where('id', $user_id);
        $this->db->update('users', $data);
    }

    public function delete_user($user_id) {
        return $this->db->delete('users', ['id' => $user_id]);
    }

    // ✅ NEW METHOD
    public function update_status($user_id, $status) {
        return $this->db->where('id', $user_id)->update('users', ['is_active' => $status]);
    }
}