<?php
class Tasks extends CI_Controller {

	public function __construct() {
		parent::__construct();
		// Load necessary models, helpers, and libraries
		$this->load->model('Task_model');
		$this->load->helper('url');
		$this->load->library('session');

		// Redirect to login if user is not logged in
		if (!$this->session->userdata('user_id')) {
			redirect('auth/login');
		}
	}

	// Display user's tasks
	public function index() {
		$user_id = $this->session->userdata('user_id');
		$data['tasks'] = $this->Task_model->get_tasks($user_id);
		$this->load->view('tasks/index', $data);
	}

	// Add a new task
	public function add() {
		$task_data = [
			'task_name' => $this->input->post('task_name'),
			'user_id' => $this->session->userdata('user_id')
		];
		$this->Task_model->add_task($task_data);
		redirect('tasks');
	}

	// Mark a task as completed
	public function complete($task_id) {
		$this->Task_model->update_task($task_id, ['status' => 'completed']);
		redirect('tasks');
	}

	// Delete a task
	public function delete($task_id) {
		$this->Task_model->delete_task($task_id);
		redirect('tasks');
	}

	// Logout the user
	public function logout() {
		$this->session->unset_userdata(['user_id', 'username']);
		redirect('auth/login');
	}
}
?>
